<?php

namespace App\Traits\Site\Payment;

use App\Models\Academic\AcademicOnlinePaymentMethod;
use App\Models\Site\Fee\Fine\SiteStudentFeeFine;
use App\Models\Site\Fee\SiteStudentFeeDemandSlipDetails;
use App\Models\Site\Fee\SiteStudentFeePaymentHistory;
use App\Models\Site\Payment\PaymentGateway;
use App\Models\Site\Payment\SiteStudentOnlinePaymentDetails;
use App\Models\Site\SiteInfo;
use App\Models\Student\StudentHistory;
use App\Models\Edu\Issue\IssueDetail;
use App\Models\User\GlobalUser;
use App\Traits\SmsFunctionsTrait;
use App\Jobs\Site\PaymentHistoryJob;
use Carbon\CarbonPeriod;
use Carbon\Carbon;
use Error;
use Exception;
use Response;

trait PaymentGatewayTrait
{
    use SmsFunctionsTrait;

    private function getDemandSlipDetails($demanSlipDetails)
    {

        if(!$demanSlipDetails){
            return false;
        }

        $slip_id = $demanSlipDetails->id;
        $slip_no = $slip_id+100000;

        $total_amount=  $demanSlipDetails->total_amount;

        //================fee fine=======================

        $due_fine_check = SiteStudentFeeFine::where('status', 1)->where('student_history_id', $demanSlipDetails->student_history_id)->get();

        $site_std_fee_fine_ids=[];
        $fee_due_fine=0;
        if(count($due_fine_check)){
            foreach ($due_fine_check as $key => $value){
                $fee_due_fine+= $value->fine_amount;
                $site_std_fee_fine_ids[$key] = $value->id;
            }

        }else{
            $fee_due_fine = 0;
        }

        $mytime = Carbon::now();
        $today_date =  $mytime->toDateString();

        $fee_delay_fine = 0;

        if($demanSlipDetails->payment_from_date && $demanSlipDetails->status){
            $start_date = $demanSlipDetails->payment_from_date;
            $end_date = $demanSlipDetails->payment_to_date;

            $period = CarbonPeriod::create($start_date, $end_date);

            $delay_fine_test = 1;

            foreach ($period as $date) {
                $formated_date =  $date->format('Y-m-d');
                if($formated_date == $today_date){
                    $delay_fine_test = 0;
                }
            }

            if($delay_fine_test==1){
                $delay_fine = $demanSlipDetails->delay_fine;
            }else{
                $delay_fine = 0;
            }

            $fee_delay_fine = $delay_fine;
        }

        $total_fee_fine = $fee_delay_fine + $fee_due_fine;
        $total_fee_fine = number_format((float)$total_fee_fine, 2, '.', '');

        $student_payment_history = SiteStudentFeePaymentHistory::where('site_student_fee_demand_slip_details_id', $slip_id)->get();

        $paid_amount = 0;

        if(count($student_payment_history)){
            foreach ($student_payment_history as $kky => $vvl){
                $paid_amount+= $vvl->paid_amount;
            }
        }


        $total_amount = $total_amount + $total_fee_fine - $paid_amount;
        $total_amount = number_format((float)$total_amount, 2, '.', '');

        $total_amount_in_word = $this->convertNumberToWord($total_amount);

        $finalArray=compact('slip_no','paid_amount','total_amount','total_amount_in_word','total_fee_fine','fee_delay_fine','fee_due_fine','site_std_fee_fine_ids');

        return $finalArray;

    }

    public function paymentReceive($data, $third_party_details, $payment_type, $transaction_by_id)
    {
        $slip_payable_amount = $data['total_amount'];
        $site_std_fee_fine_ids = $data['site_std_fee_fine_ids'];
        $fee_delay_fine =  $data['fee_delay_fine'] ?? 0;
        $slip_id = $data['slip_no'] - 100000;
        $sendSms = false;

        $payment_method = AcademicOnlinePaymentMethod::where('name_key', $payment_type)->first();

        //===================check payment transaction id present and primary table data==================
        if($transaction_by_id){
            $payment_gate_way = PaymentGateway::where('academic_payment_method_key', $payment_type)
                ->whereHas('academicOnlinePaymentMarchentType', function ($qr) {
                    return $qr->where('name_key', 'normal_marchent');
                })->first();
            if($payment_gate_way){
                $merchant_id =$payment_gate_way->partner_code;
                $order_id ="";
                $payment_ref_id =$third_party_details['txnId'];
                $paid_amount =$third_party_details['txnAmount'];
                $client_mobile_no =$third_party_details['customerNo'];
                $merchant_mobile_no ="";
                $order_date_time =$third_party_details['txnTime'];
                $issuer_payment_date_time =$third_party_details['txnTime'];
                $issuer_payment_ref_no ="";
                $payment_status ="";
                $status_code ="";

                $academic_online_payment_method_id =$payment_method->id;
                $site_id =\Session::get('SITE_ID');
            }else{
                return false;
            }
        }else{
            $payment_gate_way = PaymentGateway::where('academic_payment_method_key', $payment_type)
                ->whereHas('academicOnlinePaymentMarchentType', function ($qr) {
                    return $qr->where('name_key', 'e_commerce');
                })->first();

            if($payment_gate_way){
                if($payment_type == 'nagad'){

                    $merchant_id =$third_party_details['merchantId'];
                    $order_id =$third_party_details['orderId'];
                    $payment_ref_id =$third_party_details['paymentRefId'];
                    $paid_amount =$third_party_details['amount'];
                    $client_mobile_no =$third_party_details['clientMobileNo'];
                    $merchant_mobile_no =$third_party_details['merchantMobileNo'];
                    $order_date_time =$third_party_details['orderDateTime'];
                    $issuer_payment_date_time =$third_party_details['issuerPaymentDateTime'];
                    $issuer_payment_ref_no =$third_party_details['issuerPaymentRefNo'];
                    $payment_status =$third_party_details['status']??"";
                    $status_code =$third_party_details['statusCode']??"";
                    $trx_id = "";

                    $academic_online_payment_method_id =$payment_method->id;
                    $site_id =\Session::get('SITE_ID');

                } else if($payment_type == 'bkash') {

                    $merchant_id = $third_party_details['marchent_id'];
                    $order_id = "";
                    $payment_ref_id =$third_party_details['payment_id'];
                    $paid_amount =$third_party_details['amount'];
                    $client_mobile_no = "";
                    $merchant_mobile_no = "";
                    $order_date_time ="";
                    $issuer_payment_date_time = $third_party_details['created_time'];
                    $issuer_payment_ref_no = "";
                    $payment_status =$third_party_details['transaction_status']??"";
                    $status_code ="";
                    $trx_id = $third_party_details['trx_id']??"";

                    $academic_online_payment_method_id =$payment_method->id;
                    $site_id =\Session::get('SITE_ID');
                }


            }else{
                return false;
            }
        }

        //====================================payment insert==============================

        $demnad_slip_details = SiteStudentFeeDemandSlipDetails::where('id', $slip_id)->first();


        $student_payment_save = new SiteStudentFeePaymentHistory();
        $student_payment_save->payment_date = Carbon::today();
        $student_payment_save->site_student_fee_demand_slip_details_id = $slip_id;
        $student_payment_save->student_history_id = $demnad_slip_details->student_history_id;
        $student_payment_save->academic_payment_type_key = $payment_method->payment_type_key;
        $student_payment_save->paid_amount = $paid_amount;
        $student_payment_save->due_amount = $slip_payable_amount - $paid_amount;
        $student_payment_save->paid_by = 'bank';
        $student_payment_save->status = 1;

        $payment_history_voucher_no = SiteStudentFeePaymentHistory::orderBy('voucher_no', 'desc')->pluck('voucher_no')->first();

        if ($payment_history_voucher_no){
            $student_payment_save->voucher_no = $payment_history_voucher_no+1;
        }else{
            $student_payment_save->voucher_no = 10001;
        }

        if($student_payment_save->save()){

            //--------------------demand slip update-----------------
            if($paid_amount == $slip_payable_amount){
                $demnad_slip_details->update([
                    'status'=>0,
                ]);
            }


            //--------------------fee fine update--------------------
            $fee_fine_update = SiteStudentFeeFine::whereIn('id', $site_std_fee_fine_ids)->update([
               'status'=>0,
               'site_student_fee_payment_history_id'=>$student_payment_save->id,

            ]);

            //-----------------------create fee fine for delay-----------------
            if($fee_delay_fine > 0){
                $fee_fine = new SiteStudentFeeFine();

                $fee_fine->site_student_fee_demand_slip_details_id = $slip_id;
                $fee_fine->fine_amount = $fee_delay_fine;
                $fee_fine->student_history_id =  $demnad_slip_details->student_history_id;
                $fee_fine->site_student_fee_payment_history_id = $student_payment_save->id;
                $fee_fine->fee_type = 'delayfine';
                $fee_fine->status = 1;
                $fee_fine->accounts_received_status = 0;

                $fee_fine->save();
            }

            //--------------site student online payment details--------------

            $site_student_online_payment_details = new SiteStudentOnlinePaymentDetails();

            $site_student_online_payment_details->partner_code = $merchant_id;
            $site_student_online_payment_details->payment_gateway_id = $payment_gate_way->id;
            $site_student_online_payment_details->site_student_payment_history_id =  $student_payment_save->id;;
            $site_student_online_payment_details->student_history_id = $demnad_slip_details->student_history_id;
            $site_student_online_payment_details->transaction_amount = $paid_amount;
            $site_student_online_payment_details->transaction_status = 'paid';
            $site_student_online_payment_details->transaction_date =  Carbon::today();

            $site_student_online_payment_details->order_id =  $order_id;
            $site_student_online_payment_details->payment_ref_id =  $payment_ref_id;
            $site_student_online_payment_details->client_mobile_no =  $client_mobile_no;
            $site_student_online_payment_details->merchant_mobile_no =  $merchant_mobile_no;
            $site_student_online_payment_details->order_date_time =  $order_date_time;
            $site_student_online_payment_details->issuer_payment_date_time =  $issuer_payment_date_time;
            $site_student_online_payment_details->issuer_payment_ref_no =  $issuer_payment_ref_no;
            $site_student_online_payment_details->academic_online_payment_method_id =  $academic_online_payment_method_id;
            $site_student_online_payment_details->status_code =   $status_code;
            $site_student_online_payment_details->payment_status =  $payment_status;
            $site_student_online_payment_details->trx_id =  $trx_id;

            $site_student_online_payment_details->status = 1;


            if($site_student_online_payment_details->save()){

                //------------------------- sms --------------------------------

                if($sendSms){
                    $student_history = StudentHistory::where('id',  $demnad_slip_details->student_history_id)->with('student')->first();
                    $phone_number =  $student_history->student->contact_number;
                    $student_name = $student_history->student->full_name;
                    $paid_amount = $paid_amount;
                    $due_amount = 0;
                    $paypment_date =  Carbon::today();
                    $the_site = SiteInfo::findOrFail(Session::get('SITE_ID'));

//                        $url = config('app.url');

                    $sms_txt = "Payment Succesful";
                    $sms_txt .='nl'.$student_name;
                    $sms_txt .= 'nl'.'Paid:'.$paid_amount;
                    $sms_txt .= 'nl'.'Due:'.$due_amount;
                    $sms_txt .= 'nl'.'Payment Date:'.$paypment_date;
                    $sms_txt .= 'nl'.'Regards: '.$the_site->site_name;

                    $tt = $this->sendSms($the_site->id, $phone_number ,$sms_txt );
                }

                //---------------------------notification-------------------------

                $paymentHistoryDetails = SiteStudentFeePaymentHistory::where('student_history_id',  $demnad_slip_details->student_history_id)->where('status', 1)->with('studentHistory')->first();

                dispatch(new PaymentHistoryJob($paymentHistoryDetails));
                //-------------------------------end------------------------------
                return true;

            }else{
                return false;
            }

        }else{
            return false;
        }

    }

    public function sendSms($site_id, $numbers, $sms_txt)
    {

        try {

            $this->sendSmsUsingQueue($numbers, $sms_txt);
            return true;

        } catch (Exception $exception) {
            $issue = new    IssueDetail();
            $issue->issue_type = 'sms';
            $issue->issue_details = $exception->getMessage();
            $issue->site_id = $site_id;
            $issue->save();

            return false;


        }
    }

    public function convertNumberToWord($num = false)
    {
        $num = str_replace(array(',', ' '), '', trim($num));
        if (!$num) {
            return false;
        }
        $num = (int)$num;
        $words = array();
        $list1 = array('', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten', 'eleven',
            'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
        );
        $list2 = array('', 'ten', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety', 'hundred');
        $list3 = array('', 'thousand', 'million', 'billion', 'trillion', 'quadrillion', 'quintillion', 'sextillion', 'septillion',
            'octillion', 'nonillion', 'decillion', 'undecillion', 'duodecillion', 'tredecillion', 'quattuordecillion',
            'quindecillion', 'sexdecillion', 'septendecillion', 'octodecillion', 'novemdecillion', 'vigintillion'
        );
        $num_length = strlen($num);
        $levels = (int)(($num_length + 2) / 3);
        $max_length = $levels * 3;
        $num = substr('00' . $num, -$max_length);
        $num_levels = str_split($num, 3);
        for ($i = 0; $i < count($num_levels); $i++) {
            $levels--;
            $hundreds = (int)($num_levels[$i] / 100);
            $hundreds = ($hundreds ? ' ' . $list1[$hundreds] . ' hundred' . ' ' : '');
            $tens = (int)($num_levels[$i] % 100);
            $singles = '';
            if ($tens < 20) {
                $tens = ($tens ? ' ' . $list1[$tens] . ' ' : '');
            } else {
                $tens = (int)($tens / 10);
                $tens = ' ' . $list2[$tens] . ' ';
                $singles = (int)($num_levels[$i] % 10);
                $singles = ' ' . $list1[$singles] . ' ';
            }
            $words[] = $hundreds . $tens . $singles . (($levels && ( int )($num_levels[$i])) ? ' ' . $list3[$levels] . ' ' : '');
        } //end for loop
        $commas = count($words);
        if ($commas > 1) {
            $commas = $commas - 1;
        }
        return implode(' ', $words);
    }

}